VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsHandlerStats"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Public Function preStatString(ByVal Stat As String) As String
    Select Case UCase$(StrReverse$(Mid$(Stat, 1, 4))) 'Client String
        Case "STAR", "SEXP", "W2BN", "JSTR"
            preStatString = statstringSTAR(Stat)
        Case "WAR3", "W3XP"
            preStatString = statstringWAR3(Stat)
        Case "D2DV", "D2XP"
            preStatString = statstringD2DV(Stat)
        Case "CHAT"
            preStatString = "Chat Bot"
        Case Else
            If (Stat <> vbNullString) Then
                Debug.Print "Else: (Client): " & Client & " (Stat): " & Stat
            End If
    End Select
    
    If (preStatString = vbNullString) Then
        preStatString = "No Stats"
    End If
End Function


Public Function statstringSTAR(ByVal Stat As String) As String 'Works for clients: STAR, SEXP, JSTR, and W2BN
    Dim spltWins() As String
    If (InStr(Stat, Space(1))) Then
        spltWins() = Split(Mid$(Stat, 6), Space(1))
    End If
    
    Dim ladderLow As Integer, ladderHigh As Integer, rankLadder As Integer
    Dim Wins As Long
    
    ladderLow = spltWins(0)
        'Debug.Print "ladderLow: " & ladderLow
    rankLadder = spltWins(1)
        'Debug.Print "Rank#: " & rankLadder
    Wins = spltWins(2)
        'Debug.Print "Wins: " & Wins
    ladderHigh = spltWins(5)
        'Debug.Print "ladderHigh: " & ladderHigh
    If ladderHigh > 0 Then
        '(Ladder/High ratings: 1337/1340 with 88 wins, ranked #72)
        If rankLadder > 0 Then
            statstringSTAR = "Ladder/High ratings: " & ladderLow & "/" & ladderHigh & " with " & Wins & " wins, ranked #" & rankLadder
        Else
            statstringSTAR = "Ladder/High ratings: " & ladderLow & "/" & ladderHigh & " with " & Wins & " wins"
        End If
    Else
        statstringSTAR = Wins & " wins"
    End If
    'Debug.Print Stat
    'Debug.Print statstringSTAR
End Function

Public Function statstringD2DV(ByVal Stat As String) As String 'Works for clients: D2DV, D2XP
'Diablo II, Diablo II: LoD
'The first three fields of these statstrings contain the user's product, realm, and character name.
'Following that, the statstring contains non-textual data about the user's character.

'VD2DUSWest,WiReSRocks,
    Dim bytFlags, bytFlags2 As Byte
    Dim spltStat()  As String
    
    If (InStr(Stat, ",")) Then
        spltStat() = Split(Stat, ",")
    Else
        statstringD2DV = "Open character"
        Exit Function
    End If

    Statstring = spltStat(1) & ", level " & Asc(Mid(spltStat(2), 26, 1)) 'Character level

    bytFlags = Asc(Mid(spltStat(2), 27, 1)) 'Character flags
    bytFlags2 = Asc(Mid(spltStat(2), 27, 1)) 'Character flags 2 (difficulties beaten)
 
    If (bytFlags And &H4) = &H4 Then Statstring = Statstring & " hardcore"
    If (bytFlags And &H8) = &H8 Then Statstring = Statstring & " dead"
    If (bytFlags And &H20) = &H20 Then Statstring = Statstring & " expansion"
    If InStr(1, Statstring, "expansion") = 0 Then Statstring = Statstring & " standard" 'If they're not an expansion character must be a standard right? :O
    
    If (Mid(spltStat(2), 31, 1) = &H1) Then Statstring = Statstring & " ladder character" 'Ladder (Boolean)
    
    Select Case Asc(Mid(spltStat(2), 14, 1)) 'Character class
        Case 0: Statstring = Statstring & " Amazon"
        Case 1: Statstring = Statstring & " Sorceress"
        Case 2: Statstring = Statstring & " Necromancer"
        Case 3: Statstring = Statstring & " Paladin"
        Case 4: Statstring = Statstring & " Barbarian"
        Case 5: Statstring = Statstring & " Druid"
        Case 6: Statstring = Statstring & " Assassin"
    End Select
    
    If (bytFlags2 And &H8) = &H8 Then Statstring = Statstring & " has beaten normal, "
    If (bytFlags2 And &H10) = &H10 Then Statstring = Statstring & " hell, "
    If (bytFlags2 And &H18) = &H18 Then Statstring = Statstring & " nightmare, "
    'This is for people that haven't beaten game under any difficulties, I don't know if its right but it works so it won't cut off character class name :/
    If InStr(1, Statstring, "normal") = 0 Then Statstring = Statstring & ",  "
    Statstring = Left$(Statstring, Len(Statstring) - 2)
    
    Statstring = Statstring & " on realm " & Mid(spltStat(0), 5) 'Realm character is on
    
    statstringD2DV = Statstring
End Function

Public Function statstringWAR3(ByVal Stat As String) As String 'Works for clients: WAR3, W3XP
    'Warcraft III, Warcraft III: TFT
    'Warcraft III And it's expansion have statstings which have two, possibly three, parts.
    
    '1   Icon    The format of this contains usually always contains the user's most played race, and what icon they have for that race. This value should be matched against the product values of each icon in each MPQ icon file that is loaded. If a match is found, the client should use this icon when displaying the user. The Battle.net Warcraft III ladder icon info page (also Battle.net Frozen Throne ladder icon info) could help determine the icon. If the first character of the icon is a '1', then the user has the first icon of the specified race which is the second character of the icon ('H' is humans, 'N' is night elf, 'O' is orc, 'U' is undead, 'R' is random, and for Frozen Throne, 'D' is tournament).
    
    'The last two characters of the icon (generally is '3W') are not known right now as to what they do, but in the past for KBK they have been seen to have different values.
    '2   Level   Highest level out of all possible game types that the user has played.
    '3   Clan Tag    This is optional and will only appear if a user is in a clan.
    
    '('H' is humans, 'N' is night elf, 'O' is orc, 'U' is undead, 'R' is random, and for Frozen Throne, 'D' is tournament)
    
    Dim IconString  As String
    Dim Level       As Integer
    Dim clanTag     As String
    
    'PX3W 2R3W 18 RWOP
    'Debug.Print Stat

    Dim i           As Integer
    Dim spltStat()  As String
    If (InStr(Stat, Space(1))) Then
        spltStat() = Split(Stat, Space(1))
    Else
        Statstring = "No Stats"
        Exit Function
    End If
    'Debug.Print Stat
    'spltStat(0) -> Product
    'spltStat(1) -> Icon parsing
    'spltStat(2) -> Level
    'spltStat(3) -> Clan Tag
    
    For i = 0 To UBound(spltStat)
        'If (i = 0) Then 'spltStat(0) -> Product
        If (i = 1) Then 'spltStat(1) -> Icon parsing
            IconString = spltStat(i)
        End If
        If ((i = 2) And UBound(spltStat) > 1) Then 'spltStat(2) -> Level
            Level = spltStat(2)
        End If
        If ((i = 3) And UBound(spltStat) > 2) Then 'spltStat(3) -> Clan Tag
            clanTag = StrReverse$(spltStat(3))
        End If
    Next i
    
    'Debug.Print "iconRank: " & iconRank & " iconRace: " & iconRace & " Level: " & Level & " clanTag: " & clanTag
    If (clanTag <> vbNullString) Then
        statstringWAR3 = "Level: " & Level & ", " & GetIconTier(IconString) & " in Clan " & clanTag
    Else
        statstringWAR3 = "Level: " & Level & ", " & GetIconTier(IconString)
    End If
End Function

Private Function GetIconTier(ByRef IconString As String) As String
    
    If (getWCG(GetIconTier, IconString) = True) Then Exit Function
    
    Dim iconRace As String, iconRank As String
    
    'PX3W 2R3W 18 RWOP
    iconRace = Mid$(IconString, 2, 1)
    iconRank = Mid(IconString, 1, 1)
    
    Select Case UCase$(iconRace)
        Case "H" 'Humans
            Select Case iconRank
                Case 1: GetIconTier = "Tier: Human, Icon: Peon"
                Case 2: GetIconTier = "Tier: Human, Icon: Footman"
                Case 3: GetIconTier = "Tier: Human, Icon: Knight"
                Case 4: GetIconTier = "Tier: Human, Icon: Archmage"
                Case 5: GetIconTier = "Tier: Human, Icon: Medivh"
                Case Else: GetIconTier = "Tier: Human, Icon: Unkown"
            End Select
        Case "N" 'Night Elf
            Select Case iconRank
                Case 1: GetIconTier = "Tier: Night Elf, Icon: Peon"
                Case 2: GetIconTier = "Tier: Night Elf, Icon: Archer"
                Case 3: GetIconTier = "Tier: Night Elf, Icon: Druid of the Claw"
                Case 4: GetIconTier = "Tier: Night Elf, Icon: Priestess of the Moon"
                Case 5: GetIconTier = "Tier: Night Elf, Icon: Furion Stormrage"
                Case Else: GetIconTier = "Tier: Night Elf, Icon: Unknown"
            End Select
        Case "O" 'Orc
            Select Case iconRank
                Case 1: GetIconTier = "Tier: Orc, Icon: Peon"
                Case 2: GetIconTier = "Tier: Orc, Icon: Grunt"
                Case 3: GetIconTier = "Tier: Orc, Icon: Tauren"
                Case 4: GetIconTier = "Tier: Orc, Icon: Far Seer"
                Case 5: GetIconTier = "Tier: Orc, Icon: Thrall"
                Case Else: GetIconTier = "Tier: Orc, Icon: Unknown"
            End Select
        Case "U" 'Undead
            Select Case iconRank
                Case 1: GetIconTier = "Tier: Undead, Icon: Peon"
                Case 2: GetIconTier = "Tier: Undead, Icon: Ghoul"
                Case 3: GetIconTier = "Tier: Undead, Icon: Abomination"
                Case 4: GetIconTier = "Tier: Undead, Icon: Lich"
                Case 5: GetIconTier = "Tier: Undead, Icon: Tichondrius"
                Case Else: GetIconTier = "Tier: Undead, Icon: Unknown"
            End Select
        Case "R" 'Random
            Select Case iconRank
                Case 1: GetIconTier = "Tier: Random, Icon: Peon"
                Case 2: GetIconTier = "Tier: Random, Icon: Green Dragon Whelp"
                Case 3: GetIconTier = "Tier: Random, Icon: Blue Dragon"
                Case 4: GetIconTier = "Tier: Random, Icon: Red Dragon"
                Case 5: GetIconTier = "Tier: Random, Icon: Deathwing"
                Case Else: GetIconTier = "Tier: Random, Icon: Unknown"
            End Select
        Case "D" 'Tournament
            Select Case iconRank
                Case 1: GetIconTier = "Tier: Tournament, Icon: Peon"
                Case 2: GetIconTier = "Tier: Tournament, Icon: Felguard"
                Case 3: GetIconTier = "Tier: Tournament, Icon: Infernal"
                Case 4: GetIconTier = "Tier: Tournament, Icon: Doomguard"
                Case 5: GetIconTier = "Tier: Tournament, Icon: Pit Lord"
                Case 6: GetIconTier = "Tier: Tournament, Icon: Archimonde"
                Case Else: GetIconTier = "Tier: Tournament, Icon: Unknown"
            End Select
        Case Else
            GetIconTier = "Tier: Unknown ->" & UCase$(iconRace) & ", Icon: Unknown -> " & iconRank
    End Select
End Function

Private Function getWCG(ByRef IconTier As String, ByVal IconString As String) As Boolean
    If (Len(IconString) > 3) Then
        getWCG = True
        Select Case UCase$(StrReverse(Left$(IconString, 4)))
            Case "WCPG"
                IconTier = "Tier: Tournament, Icon: WCPG"
            Case "WCPL"
                IconTier = "Tier: Tournament, Icon: WCPL"
            Case "WCRF"
                IconTier = "Tier: Tournament, Icon: WCRF"
            Case "WCSI"
                IconTier = "Tier: Tournament, Icon: WCSI"
            Case "WCBR"
                IconTier = "Tier: Tournament, Icon: WCBR"
            Case "WCGO"
                IconTier = "Tier: Tournament, Icon: WCGO"
            Case Else
                getWCG = False
        End Select
    End If
End Function
